{
"version": 3,
"file": "leaflet-search.js",
"sources": [
"../src/geo.js",
"../src/providers/nominatim.js",
"../src/providers/geonames.js",
"../src/providers/here.js",
"../src/providers/tomtom.js",
"../src/providers/kadaster.js",
"../node_modules/lodash.debounce/index.js",
"../src/index.js"
],
"sourcesContent": [
"/** * sjaakp/leaflet-search * ---------- * Search Control for Leaflet * Version 1.0.0 * Copyright (c) 2020 * Sjaak Priester, Amsterdam * MIT License * https://github.com/sjaakp/leaflet-search * https://sjaakpriester.nl */ L.geo = { Geocoder: L.Class.extend({ initialize: function (map, options) { this._map = map; L.setOptions(this, options); }, constructUrl(text, options = {}) { const opts = Object.assign({}, this.options, options), url = new URL(text); for (const k in opts) { url.searchParams.set(k, opts[k]); } return url; }, fetchJson(url) { return fetch(url.href) .then(response => response.json()) }, placeMarker(latlng, bbox, place) { this._map.placeMarker(latlng, bbox, place); }, fire(err) { this._map.fire(err); }, suggest(address, datalist) { }, lookup(id) { } }) }; ",
" /** * sjaakp/leaflet-search * ---------- * Search Control for Leaflet * Version 1.0.0 * Copyright (c) 2020 * Sjaak Priester, Amsterdam * MIT License * https://github.com/sjaakp/leaflet-search * https://sjaakpriester.nl */ /** * @link https://nominatim.org/release-docs/develop/api/Search/ */ L.geo.Nominatim = L.geo.Geocoder.extend({ url: 'https://nominatim.openstreetmap.org/', mark(place) { const latlng = L.latLng(place.lat, place.lon), bb = place.boundingbox, bbox = L.latLngBounds([bb[0], bb[2]], [bb[1], bb[3]]); this.placeMarker(latlng, bbox, place); }, search(address) { const url = this.constructUrl(this.url + 'search', { format: 'json', q: address }); return this.fetchJson(url) }, suggest(address, datalist) { // const url = this.constructUrl(this.url + 'search', { format: 'json', q: address }); this.search(address) .then(json => { // console.log(json); datalist.innerHTML = json.reduce((a, v) => a + `<option data-id="${v.osm_type.charAt(0).toUpperCase()}${v.osm_id}">${v.display_name}</option>`, ''); }) .catch(error => this.fire(error)); }, lookup(id) { const url = this.constructUrl(this.url + 'reverse', { format: 'json', osm_type: id.charAt(0), osm_id: id.slice(1) }); this.fetchJson(url) .then(json => this.mark(json)) .catch(error => this.fire(error)); }, geocode(address) { // fetch('//nominatim.openstreetmap.org/search?format=json&q=' + encodeURIComponent(address)) // .then(response => response.json()) this.search(address) .then(json => { if (json.length < 1) throw('notfound'); return json[0]; }) .then(place => this.mark(place)) .catch(error => this.fire(error)); } }); ",
"/** * sjaakp/leaflet-search * ---------- * Search Control for Leaflet * Version 1.0.0 * Copyright (c) 2020 * Sjaak Priester, Amsterdam * MIT License * https://github.com/sjaakp/leaflet-search * https://sjaakpriester.nl */ /** * Topological names only; no streets * @link http://www.geonames.org/export/geonames-search.html */ L.geo.GeoNames = L.geo.Geocoder.extend({ url: 'http://api.geonames.org/search', // no https! fetchGeonames(url) { return this.fetchJson(url) .then(json => { const geonames = json.geonames; if (! geonames || geonames.length < 1) throw 'notfound'; return geonames; }) }, mark(place) { const latlng = L.latLng(place.lat, place.lng), bb = place.bbox, bbox = L.latLngBounds([bb.north, bb.west], [bb.south, bb.east]); this.placeMarker(latlng, bbox, place); }, suggest(address, datalist) { const url = this.constructUrl(this.url, { q: address, type: 'json', style: 'short' }); this.fetchGeonames(url) .then(geonames => { datalist.innerHTML = geonames.reduce((a, v) => a + `<option data-id="${v.geonameId}">${v.name}&emsp;${v.countryCode}</option>`, ''); }) .catch(error => this.fire(error)); }, lookup(id) { const url = this.constructUrl('http://api.geonames.org/getJSON', { geonameId: id }); this.fetchJson(url) .then(json => this.mark(json)) .catch(error => this.fire(error)); }, geocode(address) { const url = this.constructUrl(this.url, { q: address, inclBbox: true }); this.fetchGeonames(url) .then(geonames => geonames.shift()) .then(place => this.mark(place)) .catch(error => this.fire(error)); } }); ",
"/** * sjaakp/leaflet-search * ---------- * Search Control for Leaflet * Version 1.0.0 * Copyright (c) 2020 * Sjaak Priester, Amsterdam * MIT License * https://github.com/sjaakp/leaflet-search * https://sjaakpriester.nl */ /** * @link https://developer.here.com/documentation/geocoder/dev_guide/topics/request-constructing.html */ L.geo.Here = L.geo.Geocoder.extend({ mark(place) { const pos = place.displayPosition, latlng = L.latLng(pos.latitude, pos.longitude), mapv = place.mapView, tl = mapv.topLeft, br = mapv.bottomRight, bbox = L.latLngBounds([tl.latitude, br.longitude], [br.latitude, tl.longitude]); this.placeMarker(latlng, bbox, place); }, fetchData(options) { options.jsonattributes = 1; const url = this.constructUrl('https://geocoder.ls.hereapi.com/6.2/geocode.json', options); this.fetchJson(url) .then(json => json.response.view.shift().result.shift()) .then(result => this.mark(result.location)) .catch(error => this.fire(error)); }, suggest(address, datalist) { const url = this.constructUrl('https://autocomplete.geocoder.ls.hereapi.com/6.2/suggest.json', { query: address }); this.fetchJson(url) .then(json => json.suggestions) .then(suggestions => { datalist.innerHTML = suggestions.reduce((a, v) => a + `<option data-id="${v.locationId}">${v.label}</option>`, ''); }) .catch(error => this.fire(error)); }, lookup(id) { this.fetchData({ locationid: id }); }, geocode(address) { this.fetchData({ searchtext: address }); } }); ",
"/** * sjaakp/leaflet-search * ---------- * Search Control for Leaflet * Version 1.0.0 * Copyright (c) 2020 * Sjaak Priester, Amsterdam * MIT License * https://github.com/sjaakp/leaflet-search * https://sjaakpriester.nl */ /** * @link https://developer.tomtom.com/search-api-and-extended-search-api/search-api-and-extended-search-api-documentation-geocoding/geocode */ L.geo.TomTom = L.geo.Geocoder.extend({ url: 'https://api.tomtom.com/search/2/geocode/', suggestions: [], datalist: null, mark(place) { const pos = place.position, latlng = L.latLng(pos.lat, pos.lon), mapv = place.viewport, tl = mapv.topLeftPoint, br = mapv.btmRightPoint, bbox = L.latLngBounds([tl.lat, br.lon], [br.lat, tl.lon]); this.placeMarker(latlng, bbox, place); }, fetchResults(address, options = {}) { const query = encodeURIComponent(address), url = this.constructUrl(`${this.url}${query}.json`, options); return this.fetchJson(url) .then(json => { if (json.summary.numResults < 1) throw('notfound'); return json.results; }) }, suggest(address, datalist) { this.datalist = datalist; this.fetchResults(address,{ typeahead: true }) .then(results => { this.suggestions = results; datalist.innerHTML = results.reduce((a, v) => a + `<option data-id="${v.id}">${v.address.freeformAddress}</option>`, ''); }) .catch(error => this.fire(error)); }, lookup(id) { const found = this.suggestions.find(v => v.id === id); if (found) this.mark(found); }, geocode(address) { this.fetchResults(address) .then(results => results.shift()) .then(place => this.mark(place)) .catch(error => this.fire(error)); } }); ",
"/** * sjaakp/leaflet-search * ---------- * Search Control for Leaflet * Version 1.0.0 * Copyright (c) 2020 * Sjaak Priester, Amsterdam * MIT License * https://github.com/sjaakp/leaflet-search * https://sjaakpriester.nl */ /** * Netherlands * @link https://github.com/PDOK/locatieserver/wiki/API-Locatieserver */ L.geo.Kadaster = L.geo.Geocoder.extend({ url: 'https://geodata.nationaalgeoregister.nl/locatieserver/v3/', mark(place) { this.placeMarker(place.centroide_ll.match(/[\d.]+/g).reverse(), null, place); }, suggest(address, datalist) { const url = this.constructUrl(this.url + 'suggest', { q: address + ' and -type:postcode' }); this.fetchJson(url) .then(json => { if (json.response.numFound < 1) throw('notfound'); return json.highlighting; }) .then(hilight => { let html = ''; for (const id in hilight) { const opt = `<option data-id="${id}">${hilight[id].suggest.shift()}</option>`; html += opt; } datalist.innerHTML = html; }) .catch(error => this.fire(error)); }, lookup(id) { const url = this.constructUrl(this.url + 'lookup', { id: id }); this.fetchJson(url) .then(json => json.response.docs.shift()) .then(place => this.mark(place)) .catch(error => this.fire(error)); }, geocode(address) { const url = this.constructUrl(this.url + 'free', { q: address + ' and -type:postcode' }); this.fetchJson(url) .then(json => { if (json.response.numFound < 1) throw('notfound'); return json.response.docs.shift(); }) .then(place => this.mark(place)) .catch(error => this.fire(error)); } }); ",
"/** * lodash (Custom Build) <https://lodash.com/> * Build: `lodash modularize exports="npm" -o ./` * Copyright jQuery Foundation and other contributors <https://jquery.org/> * Released under MIT license <https://lodash.com/license> * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE> * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors */ /** Used as the `TypeError` message for "Functions" methods. */ var FUNC_ERROR_TEXT = 'Expected a function'; /** Used as references for various `Number` constants. */ var NAN = 0 / 0; /** `Object#toString` result references. */ var symbolTag = '[object Symbol]'; /** Used to match leading and trailing whitespace. */ var reTrim = /^\s+|\s+$/g; /** Used to detect bad signed hexadecimal string values. */ var reIsBadHex = /^[-+]0x[0-9a-f]+$/i; /** Used to detect binary string values. */ var reIsBinary = /^0b[01]+$/i; /** Used to detect octal string values. */ var reIsOctal = /^0o[0-7]+$/i; /** Built-in method references without a dependency on `root`. */ var freeParseInt = parseInt; /** Detect free variable `global` from Node.js. */ var freeGlobal = typeof global == 'object' && global && global.Object === Object && global; /** Detect free variable `self`. */ var freeSelf = typeof self == 'object' && self && self.Object === Object && self; /** Used as a reference to the global object. */ var root = freeGlobal || freeSelf || Function('return this')(); /** Used for built-in method references. */ var objectProto = Object.prototype; /** * Used to resolve the * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring) * of values. */ var objectToString = objectProto.toString; /* Built-in method references for those with the same name as other `lodash` methods. */ var nativeMax = Math.max, nativeMin = Math.min; /** * Gets the timestamp of the number of milliseconds that have elapsed since * the Unix epoch (1 January 1970 00:00:00 UTC). * * @static * @memberOf _ * @since 2.4.0 * @category Date * @returns {number} Returns the timestamp. * @example * * _.defer(function(stamp) { * console.log(_.now() - stamp); * }, _.now()); * // => Logs the number of milliseconds it took for the deferred invocation. */ var now = function() { return root.Date.now(); }; /** * Creates a debounced function that delays invoking `func` until after `wait` * milliseconds have elapsed since the last time the debounced function was * invoked. The debounced function comes with a `cancel` method to cancel * delayed `func` invocations and a `flush` method to immediately invoke them. * Provide `options` to indicate whether `func` should be invoked on the * leading and/or trailing edge of the `wait` timeout. The `func` is invoked * with the last arguments provided to the debounced function. Subsequent * calls to the debounced function return the result of the last `func` * invocation. * * **Note:** If `leading` and `trailing` options are `true`, `func` is * invoked on the trailing edge of the timeout only if the debounced function * is invoked more than once during the `wait` timeout. * * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred * until to the next tick, similar to `setTimeout` with a timeout of `0`. * * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/) * for details over the differences between `_.debounce` and `_.throttle`. * * @static * @memberOf _ * @since 0.1.0 * @category Function * @param {Function} func The function to debounce. * @param {number} [wait=0] The number of milliseconds to delay. * @param {Object} [options={}] The options object. * @param {boolean} [options.leading=false] * Specify invoking on the leading edge of the timeout. * @param {number} [options.maxWait] * The maximum time `func` is allowed to be delayed before it's invoked. * @param {boolean} [options.trailing=true] * Specify invoking on the trailing edge of the timeout. * @returns {Function} Returns the new debounced function. * @example * * // Avoid costly calculations while the window size is in flux. * jQuery(window).on('resize', _.debounce(calculateLayout, 150)); * * // Invoke `sendMail` when clicked, debouncing subsequent calls. * jQuery(element).on('click', _.debounce(sendMail, 300, { * 'leading': true, * 'trailing': false * })); * * // Ensure `batchLog` is invoked once after 1 second of debounced calls. * var debounced = _.debounce(batchLog, 250, { 'maxWait': 1000 }); * var source = new EventSource('/stream'); * jQuery(source).on('message', debounced); * * // Cancel the trailing debounced invocation. * jQuery(window).on('popstate', debounced.cancel); */ function debounce(func, wait, options) { var lastArgs, lastThis, maxWait, result, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true; if (typeof func != 'function') { throw new TypeError(FUNC_ERROR_TEXT); } wait = toNumber(wait) || 0; if (isObject(options)) { leading = !!options.leading; maxing = 'maxWait' in options; maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait; trailing = 'trailing' in options ? !!options.trailing : trailing; } function invokeFunc(time) { var args = lastArgs, thisArg = lastThis; lastArgs = lastThis = undefined; lastInvokeTime = time; result = func.apply(thisArg, args); return result; } function leadingEdge(time) { // Reset any `maxWait` timer. lastInvokeTime = time; // Start the timer for the trailing edge. timerId = setTimeout(timerExpired, wait); // Invoke the leading edge. return leading ? invokeFunc(time) : result; } function remainingWait(time) { var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, result = wait - timeSinceLastCall; return maxing ? nativeMin(result, maxWait - timeSinceLastInvoke) : result; } function shouldInvoke(time) { var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime; // Either this is the first call, activity has stopped and we're at the // trailing edge, the system time has gone backwards and we're treating // it as the trailing edge, or we've hit the `maxWait` limit. return (lastCallTime === undefined || (timeSinceLastCall >= wait) || (timeSinceLastCall < 0) || (maxing && timeSinceLastInvoke >= maxWait)); } function timerExpired() { var time = now(); if (shouldInvoke(time)) { return trailingEdge(time); } // Restart the timer. timerId = setTimeout(timerExpired, remainingWait(time)); } function trailingEdge(time) { timerId = undefined; // Only invoke if we have `lastArgs` which means `func` has been // debounced at least once. if (trailing && lastArgs) { return invokeFunc(time); } lastArgs = lastThis = undefined; return result; } function cancel() { if (timerId !== undefined) { clearTimeout(timerId); } lastInvokeTime = 0; lastArgs = lastCallTime = lastThis = timerId = undefined; } function flush() { return timerId === undefined ? result : trailingEdge(now()); } function debounced() { var time = now(), isInvoking = shouldInvoke(time); lastArgs = arguments; lastThis = this; lastCallTime = time; if (isInvoking) { if (timerId === undefined) { return leadingEdge(lastCallTime); } if (maxing) { // Handle invocations in a tight loop. timerId = setTimeout(timerExpired, wait); return invokeFunc(lastCallTime); } } if (timerId === undefined) { timerId = setTimeout(timerExpired, wait); } return result; } debounced.cancel = cancel; debounced.flush = flush; return debounced; } /** * Checks if `value` is the * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types) * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`) * * @static * @memberOf _ * @since 0.1.0 * @category Lang * @param {*} value The value to check. * @returns {boolean} Returns `true` if `value` is an object, else `false`. * @example * * _.isObject({}); * // => true * * _.isObject([1, 2, 3]); * // => true * * _.isObject(_.noop); * // => true * * _.isObject(null); * // => false */ function isObject(value) { var type = typeof value; return !!value && (type == 'object' || type == 'function'); } /** * Checks if `value` is object-like. A value is object-like if it's not `null` * and has a `typeof` result of "object". * * @static * @memberOf _ * @since 4.0.0 * @category Lang * @param {*} value The value to check. * @returns {boolean} Returns `true` if `value` is object-like, else `false`. * @example * * _.isObjectLike({}); * // => true * * _.isObjectLike([1, 2, 3]); * // => true * * _.isObjectLike(_.noop); * // => false * * _.isObjectLike(null); * // => false */ function isObjectLike(value) { return !!value && typeof value == 'object'; } /** * Checks if `value` is classified as a `Symbol` primitive or object. * * @static * @memberOf _ * @since 4.0.0 * @category Lang * @param {*} value The value to check. * @returns {boolean} Returns `true` if `value` is a symbol, else `false`. * @example * * _.isSymbol(Symbol.iterator); * // => true * * _.isSymbol('abc'); * // => false */ function isSymbol(value) { return typeof value == 'symbol' || (isObjectLike(value) && objectToString.call(value) == symbolTag); } /** * Converts `value` to a number. * * @static * @memberOf _ * @since 4.0.0 * @category Lang * @param {*} value The value to process. * @returns {number} Returns the number. * @example * * _.toNumber(3.2); * // => 3.2 * * _.toNumber(Number.MIN_VALUE); * // => 5e-324 * * _.toNumber(Infinity); * // => Infinity * * _.toNumber('3.2'); * // => 3.2 */ function toNumber(value) { if (typeof value == 'number') { return value; } if (isSymbol(value)) { return NAN; } if (isObject(value)) { var other = typeof value.valueOf == 'function' ? value.valueOf() : value; value = isObject(other) ? (other + '') : other; } if (typeof value != 'string') { return value === 0 ? value : +value; } value = value.replace(reTrim, ''); var isBinary = reIsBinary.test(value); return (isBinary || reIsOctal.test(value)) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : (reIsBadHex.test(value) ? NAN : +value); } module.exports = debounce; ",
"/** * sjaakp/leaflet-search * ---------- * Search Control for Leaflet * Version 1.0.0 * Copyright (c) 2020 * Sjaak Priester, Amsterdam * MIT License * https://github.com/sjaakp/leaflet-search * https://sjaakpriester.nl */ /* * L.Map acquires two extra options: * - createMarker: function to create new marker after geofound. If not set: L.marker. * - fly: bool, whether fly animation is used to move to found location. * * One extra property: * - marker: if set, Search moves this marker to the found location, otherwise (default) creates new marker. * * Two extra methods: * - addGeocoder(name, options?): add geocoder to map, with name and options. * - geocode(address): try to find address and place marker there. * * Two extra events: * - 'geofound': data = { latlng: <latlng>, bbox: <boundingBox>, place: <all data from geocoder> } * - 'notfound': no result from geocoder */ import './geo.scss'; import './geo.js'; import './providers/nominatim.js'; import './providers/geonames.js'; import './providers/here.js'; import './providers/tomtom.js'; import './providers/kadaster.js'; import debounce from 'lodash.debounce'; L.Control.Search = L.Control.extend({ initialize(options) { L.setOptions(this, L.extend({ debounce: 300, suggest: 2 }, options)); }, onAdd(map) { const datalistId = map.getContainer().id + '_dl'; const container = L.DomUtil.create('div', 'geo-search'); const input = L.DomUtil.create('input', null, container); input.type = 'text'; input.setAttribute('list', datalistId); L.DomEvent.on(input, 'input', debounce(function(e) { const v = e.target.value; if (v.length >= this.options.suggest) { map._geocoder.suggest(e.target.value, datalist); } }, this.options.debounce), this); L.DomEvent.on(input, 'change', function (e) { const val = e.target.value, opts = datalist.childNodes; e.target.value = ''; container.classList.remove('open'); for (let i = 0; i < opts.length; i++) { if (val.startsWith(opts[i].innerText)) { this._geocoder.lookup(opts[i].dataset.id); return; } } this.geocode(val); }, map); const button = L.DomUtil.create('button', null, container); button.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M505 442.7L405.3 343c-4.5-4.5-10.6-7-17-7H372c27.6-35.3 44-79.7 44-128C416 93.1 322.9 0 208 0S0 93.1 0 208s93.1 208 208 208c48.3 0 92.7-16.4 128-44v16.3c0 6.4 2.5 12.5 7 17l99.7 99.7c9.4 9.4 24.6 9.4 33.9 0l28.3-28.3c9.4-9.4 9.4-24.6.1-34zM208 336c-70.7 0-128-57.2-128-128 0-70.7 57.2-128 128-128 70.7 0 128 57.2 128 128 0 70.7-57.2 128-128 128z"/></svg>'; button.title = 'Search'; L.DomEvent.on(button, 'click', function(e) { e.preventDefault(); e.stopPropagation(); this.toggle(); }, this); const datalist = L.DomUtil.create('datalist', null, container); datalist.id = datalistId; return container; }, toggle() { const c = this.getContainer(), cc = c.classList, bOpen = cc.contains('open'); cc.toggle('open'); if (! bOpen) { c.children[0].focus(); } }, }); L.control.search = function(options) { return new L.Control.Search(options); }; L.Map.include({ marker: null, placeMarker(latlng, bbox, place) { this.fire('geofound', { latlng: latlng, bbox: bbox, place: place }); if (this.marker) { this.marker.setLatLng(latlng); } else { const createMarker = this.options.createMarker || L.marker; this.marker = createMarker(latlng).addTo(this); } if (this.options.fly) { if (bbox) this.flyToBounds(bbox); else this.flyTo(latlng); } else { if (bbox) this.fitBounds(bbox); else this.panTo(latlng); } }, geocode(address) { this._geocoder.geocode(address); return this; }, setGeocoder(name, options = {}) { this._geocoder = new L.geo[name](this, options); return this; }, }); L.Map.addInitHook(function() { this.setGeocoder('Nominatim', {}); }); "
],
"names": [
"L",
"geo",
"Geocoder",
"Class",
"extend",
"initialize",
"map",
"options",
"this",
"_map",
"setOptions",
"constructUrl",
"text",
"const",
"opts",
"Object",
"assign",
"url",
"URL",
"k",
"searchParams",
"set",
"fetchJson",
"fetch",
"href",
"then",
"response",
"json",
"placeMarker",
"latlng",
"bbox",
"place",
"fire",
"err",
"suggest",
"address",
"datalist",
"lookup",
"id",
"Nominatim",
"mark",
"latLng",
"lat",
"lon",
"bb",
"boundingbox",
"latLngBounds",
"search",
"format",
"q",
"innerHTML",
"reduce",
"a",
"v",
"osm_type",
"charAt",
"toUpperCase",
"catch",
"error",
"osm_id",
"slice",
"geocode",
"length",
"GeoNames",
"fetchGeonames",
"geonames",
"lng",
"north",
"west",
"south",
"east",
"type",
"style",
"geonameId",
"inclBbox",
"shift",
"Here",
"pos",
"displayPosition",
"latitude",
"longitude",
"mapv",
"mapView",
"tl",
"topLeft",
"br",
"bottomRight",
"fetchData",
"jsonattributes",
"view",
"result",
"location",
"query",
"suggestions",
"locationid",
"searchtext",
"TomTom",
"position",
"viewport",
"topLeftPoint",
"btmRightPoint",
"fetchResults",
"encodeURIComponent",
"summary",
"numResults",
"results",
"typeahead",
"found",
"find",
"Kadaster",
"centroide_ll",
"match",
"reverse",
"numFound",
"highlighting",
"hilight",
"let",
"html",
"docs",
"reTrim",
"reIsBadHex",
"reIsBinary",
"reIsOctal",
"freeParseInt",
"parseInt",
"freeGlobal",
"global",
"freeSelf",
"self",
"root",
"Function",
"objectToString",
"prototype",
"toString",
"nativeMax",
"Math",
"max",
"nativeMin",
"min",
"now",
"Date",
"isObject",
"value",
"toNumber",
"isObjectLike",
"call",
"isSymbol",
"other",
"valueOf",
"replace",
"isBinary",
"test",
"func",
"wait",
"lastArgs",
"lastThis",
"maxWait",
"timerId",
"lastCallTime",
"lastInvokeTime",
"leading",
"maxing",
"trailing",
"TypeError",
"invokeFunc",
"time",
"args",
"thisArg",
"undefined",
"apply",
"leadingEdge",
"setTimeout",
"timerExpired",
"shouldInvoke",
"timeSinceLastCall",
"trailingEdge",
"remainingWait",
"debounced",
"isInvoking",
"arguments",
"cancel",
"clearTimeout",
"flush",
"Control",
"Search",
"debounce",
"onAdd",
"datalistId",
"getContainer",
"container",
"DomUtil",
"create",
"input",
"setAttribute",
"DomEvent",
"on",
"e",
"target",
"_geocoder",
"val",
"childNodes",
"classList",
"remove",
"i",
"startsWith",
"innerText",
"dataset",
"button",
"title",
"preventDefault",
"stopPropagation",
"toggle",
"c",
"cc",
"bOpen",
"contains",
"children",
"focus",
"control",
"Map",
"include",
"marker",
"setLatLng",
"createMarker",
"addTo",
"fly",
"flyToBounds",
"flyTo",
"fitBounds",
"panTo",
"setGeocoder",
"name",
"addInitHook"
],
"mappings": ";;;;;;;ypBAYAA,EAAEC,IAAM,CACJC,SAAUF,EAAEG,MAAMC,OAAO,CACrBC,WAAY,SAAUC,EAAKC,GACvBC,KAAKC,KAAOH,EACZN,EAAEU,WAAWF,KAAMD,IAGvBI,sBAAaC,EAAML,kBAAU,IACzBM,IAAMC,EAAOC,OAAOC,OAAO,GAAIR,KAAKD,QAASA,GACzCU,EAAM,IAAIC,IAAIN,GAClB,IAAKC,IAAMM,KAAKL,EACZG,EAAIG,aAAaC,IAAIF,EAAGL,EAAKK,IAEjC,OAAOF,GAGXK,mBAAUL,GACN,OAAOM,MAAMN,EAAIO,MACZC,eAAKC,UAAYA,EAASC,WAGnCC,qBAAYC,EAAQC,EAAMC,GACtBvB,KAAKC,KAAKmB,YAAYC,EAAQC,EAAMC,IAGxCC,cAAKC,GACDzB,KAAKC,KAAKuB,KAAKC,IAGnBC,iBAAQC,EAASC,KAGjBC,gBAAOC,QC5BftC,EAAEC,IAAIsC,UAAYvC,EAAEC,IAAIC,SAASE,OAAO,CACpCa,IAAK,uCAELuB,cAAKT,GACDlB,IAAMgB,EAAS7B,EAAEyC,OAAOV,EAAMW,IAAKX,EAAMY,KACrCC,EAAKb,EAAMc,YACXf,EAAO9B,EAAE8C,aAAa,CAACF,EAAG,GAAIA,EAAG,IAAK,CAACA,EAAG,GAAIA,EAAG,KACrDpC,KAAKoB,YAAYC,EAAQC,EAAMC,IAGnCgB,gBAAOZ,GACHtB,IAAMI,EAAMT,KAAKG,aAAaH,KAAKS,IAAM,SAAU,CAAE+B,OAAQ,OAAQC,EAAGd,IACxE,OAAO3B,KAAKc,UAAUL,IAG1BiB,iBAAQC,EAASC,cAEb5B,KAAKuC,OAAOZ,GACPV,eAAKE,GAEFS,EAASc,UAAYvB,EAAKwB,iBAAQC,EAAGC,UAAMD,EAAI,oBAAoBC,EAAEC,SAASC,OAAO,GAAGC,cAAgBH,cAAaA,6BAA2B,OAEnJI,gBAAMC,UAASlD,EAAKwB,KAAK0B,OAGlCrB,gBAAOC,cACGrB,EAAMT,KAAKG,aAAaH,KAAKS,IAAM,UAAW,CAChD+B,OAAQ,OACRM,SAAUhB,EAAGiB,OAAO,GACpBI,OAAQrB,EAAGsB,MAAM,KAErBpD,KAAKc,UAAUL,GACVQ,eAAKE,UAAQnB,EAAKgC,KAAKb,MACvB8B,gBAAMC,UAASlD,EAAKwB,KAAK0B,OAGlCG,iBAAQ1B,cAGJ3B,KAAKuC,OAAOZ,GACPV,eAAKE,GACF,GAAIA,EAAKmC,OAAS,EAAG,gBACrB,OAAOnC,EAAK,MAEfF,eAAKM,UAASvB,EAAKgC,KAAKT,MACxB0B,gBAAMC,UAASlD,EAAKwB,KAAK0B,SC7CtC1D,EAAEC,IAAI8D,SAAW/D,EAAEC,IAAIC,SAASE,OAAO,CACnCa,IAAK,iCAEL+C,uBAAc/C,GACV,OAAOT,KAAKc,UAAUL,GACjBQ,eAAKE,GACFd,IAAMoD,EAAWtC,EAAKsC,SACtB,IAAMA,GAAYA,EAASH,OAAS,EAAG,KAAM,WAC7C,OAAOG,MAInBzB,cAAKT,GACDlB,IAAMgB,EAAS7B,EAAEyC,OAAOV,EAAMW,IAAKX,EAAMmC,KACrCtB,EAAKb,EAAMD,KACXA,EAAO9B,EAAE8C,aAAa,CAACF,EAAGuB,MAAOvB,EAAGwB,MAAO,CAACxB,EAAGyB,MAAOzB,EAAG0B,OAC7D9D,KAAKoB,YAAYC,EAAQC,EAAMC,IAGnCG,iBAAQC,EAASC,cACPnB,EAAMT,KAAKG,aAAaH,KAAKS,IAAK,CAAEgC,EAAGd,EAASoC,KAAM,OAAQC,MAAO,UAE3EhE,KAAKwD,cAAc/C,GACdQ,eAAKwC,GACF7B,EAASc,UAAYe,EAASd,iBAAQC,EAAGC,UAAMD,EAAI,oBAAoBC,iBAAgBA,gBAAeA,4BAA0B,OAEnII,gBAAMC,UAASlD,EAAKwB,KAAK0B,OAGlCrB,gBAAOC,cACGrB,EAAMT,KAAKG,aAAa,kCAAmC,CAAE8D,UAAWnC,IAE9E9B,KAAKc,UAAUL,GACVQ,eAAKE,UAAQnB,EAAKgC,KAAKb,MACvB8B,gBAAMC,UAASlD,EAAKwB,KAAK0B,OAGlCG,iBAAQ1B,cACElB,EAAMT,KAAKG,aAAaH,KAAKS,IAAK,CAAEgC,EAAGd,EAASuC,UAAU,IAEhElE,KAAKwD,cAAc/C,GACdQ,eAAKwC,UAAYA,EAASU,WAC1BlD,eAAKM,UAASvB,EAAKgC,KAAKT,MACxB0B,gBAAMC,UAASlD,EAAKwB,KAAK0B,SC5CtC1D,EAAEC,IAAI2E,KAAO5E,EAAEC,IAAIC,SAASE,OAAO,CAC/BoC,cAAKT,GACDlB,IAAMgE,EAAM9C,EAAM+C,gBACdjD,EAAS7B,EAAEyC,OAAOoC,EAAIE,SAAUF,EAAIG,WACpCC,EAAOlD,EAAMmD,QACbC,EAAKF,EAAKG,QACVC,EAAKJ,EAAKK,YACVxD,EAAO9B,EAAE8C,aAAa,CAACqC,EAAGJ,SAAUM,EAAGL,WAAY,CAACK,EAAGN,SAAUI,EAAGH,YACxExE,KAAKoB,YAAYC,EAAQC,EAAMC,IAGnCwD,mBAAUhF,cACNA,EAAQiF,eAAiB,EACzB3E,IAAMI,EAAMT,KAAKG,aAAa,mDAAoDJ,GAClFC,KAAKc,UAAUL,GACVQ,eAAKE,UAAQA,EAAKD,SAAS+D,KAAKd,QAAQe,OAAOf,WAC/ClD,eAAKiE,UAAUlF,EAAKgC,KAAKkD,EAAOC,aAChClC,gBAAMC,UAASlD,EAAKwB,KAAK0B,OAGlCxB,iBAAQC,EAASC,cACPnB,EAAMT,KAAKG,aAAa,gEAAiE,CAAEiF,MAAOzD,IACxG3B,KAAKc,UAAUL,GACVQ,eAAKE,UAAQA,EAAKkE,eAClBpE,eAAKoE,GACFzD,EAASc,UAAY2C,EAAY1C,iBAAQC,EAAGC,UAAMD,EAAI,oBAAoBC,kBAAiBA,sBAAoB,OAElHI,gBAAMC,UAASlD,EAAKwB,KAAK0B,OAGlCrB,gBAAOC,GACH9B,KAAK+E,UAAU,CAAEO,WAAYxD,KAGjCuB,iBAAQ1B,GACJ3B,KAAK+E,UAAU,CAAEQ,WAAY5D,OCnCrCnC,EAAEC,IAAI+F,OAAShG,EAAEC,IAAIC,SAASE,OAAO,CACjCa,IAAK,2CAEL4E,YAAa,GAEbzD,SAAU,KAEVI,cAAKT,GACDlB,IAAMgE,EAAM9C,EAAMkE,SACdpE,EAAS7B,EAAEyC,OAAOoC,EAAInC,IAAKmC,EAAIlC,KAC/BsC,EAAOlD,EAAMmE,SACbf,EAAKF,EAAKkB,aACVd,EAAKJ,EAAKmB,cACVtE,EAAO9B,EAAE8C,aAAa,CAACqC,EAAGzC,IAAK2C,EAAG1C,KAAM,CAAC0C,EAAG3C,IAAKyC,EAAGxC,MACxDnC,KAAKoB,YAAYC,EAAQC,EAAMC,IAGnCsE,sBAAalE,EAAS5B,kBAAU,IAC5BM,IAAM+E,EAAQU,mBAAmBnE,GAC7BlB,EAAMT,KAAKG,gBAAgBH,SAAWoF,UAAcrF,GAExD,OAAOC,KAAKc,UAAUL,GACjBQ,eAAKE,GACF,GAAIA,EAAK4E,QAAQC,WAAa,EAAG,gBACjC,OAAO7E,EAAK8E,YAIxBvE,iBAAQC,EAASC,cACb5B,KAAK4B,SAAWA,EAChB5B,KAAK6F,aAAalE,EAAQ,CAAEuE,WAAW,IAClCjF,eAAKgF,GACFjG,EAAKqF,YAAcY,EACnBrE,EAASc,UAAYuD,EAAQtD,iBAAQC,EAAGC,UAAMD,EAAI,oBAAoBC,UAASA,EAAElB,sCAAoC,OAExHsB,gBAAMC,UAASlD,EAAKwB,KAAK0B,OAGlCrB,gBAAOC,GACHzB,IAAM8F,EAAQnG,KAAKqF,YAAYe,eAAKvD,UAAKA,EAAEf,KAAOA,KAC9CqE,GAAOnG,KAAKgC,KAAKmE,IAGzB9C,iBAAQ1B,cACJ3B,KAAK6F,aAAalE,GACbV,eAAKgF,UAAWA,EAAQ9B,WACxBlD,eAAKM,UAASvB,EAAKgC,KAAKT,MACxB0B,gBAAMC,UAASlD,EAAKwB,KAAK0B,SC9CtC1D,EAAEC,IAAI4G,SAAW7G,EAAEC,IAAIC,SAASE,OAAO,CACnCa,IAAK,4DAELuB,cAAKT,GACDvB,KAAKoB,YAAYG,EAAM+E,aAAaC,MAAM,WAAWC,UAAW,KAAMjF,IAG1EG,iBAAQC,EAASC,cACPnB,EAAMT,KAAKG,aAAaH,KAAKS,IAAM,UAAW,CAAEgC,EAAGd,EAAU,wBACnE3B,KAAKc,UAAUL,GACVQ,eAAKE,GACF,GAAIA,EAAKD,SAASuF,SAAW,EAAG,gBAChC,OAAOtF,EAAKuF,gBAEfzF,eAAK0F,GACFC,IAAIC,EAAO,GACX,IAAKxG,IAAMyB,KAAM6E,EAAS,CAEtBE,GADY,oBAAoB/E,OAAO6E,EAAQ7E,GAAIJ,QAAQyC,oBAG/DvC,EAASc,UAAYmE,KAExB5D,gBAAMC,UAASlD,EAAKwB,KAAK0B,OAGlCrB,gBAAOC,cACGrB,EAAMT,KAAKG,aAAaH,KAAKS,IAAM,SAAU,CAAEqB,GAAIA,IACzD9B,KAAKc,UAAUL,GACVQ,eAAKE,UAAQA,EAAKD,SAAS4F,KAAK3C,WAChClD,eAAKM,UAASvB,EAAKgC,KAAKT,MACxB0B,gBAAMC,UAASlD,EAAKwB,KAAK0B,OAGlCG,iBAAQ1B,cACElB,EAAMT,KAAKG,aAAaH,KAAKS,IAAM,OAAQ,CAAEgC,EAAGd,EAAU,wBAChE3B,KAAKc,UAAUL,GACVQ,eAAKE,GACF,GAAIA,EAAKD,SAASuF,SAAW,EAAG,gBAChC,OAAOtF,EAAKD,SAAS4F,KAAK3C,WAE7BlD,eAAKM,UAASvB,EAAKgC,KAAKT,MACxB0B,gBAAMC,UAASlD,EAAKwB,KAAK0B,8JCtClC6D,EAAS,aAGTC,EAAa,qBAGbC,EAAa,aAGbC,EAAY,cAGZC,EAAeC,SAGfC,EAA8B,iBAAVC,GAAsBA,GAAUA,EAAO/G,SAAWA,QAAU+G,EAGhFC,EAA0B,iBAARC,MAAoBA,MAAQA,KAAKjH,SAAWA,QAAUiH,KAGxEC,EAAOJ,GAAcE,GAAYG,SAAS,cAATA,GAUjCC,EAPcpH,OAAOqH,UAOQC,SAG7BC,EAAYC,KAAKC,IACjBC,EAAYF,KAAKG,IAkBjBC,EAAM,WACR,OAAOV,EAAKW,KAAKD,OA4MnB,SAASE,EAASC,GAChB,IAAIvE,SAAcuE,EAClB,QAASA,IAAkB,UAARvE,GAA4B,YAARA,GA4EzC,SAASwE,EAASD,GAChB,GAAoB,iBAATA,EACT,OAAOA,EAET,GAhCF,SAAkBA,GAChB,MAAuB,iBAATA,GAtBhB,SAAsBA,GACpB,QAASA,GAAyB,iBAATA,EAsBtBE,CAAaF,IAzTF,mBAyTYX,EAAec,KAAKH,GA8B1CI,CAASJ,GACX,OA3VM,IA6VR,GAAID,EAASC,GAAQ,CACnB,IAAIK,EAAgC,mBAAjBL,EAAMM,QAAwBN,EAAMM,UAAYN,EACnEA,EAAQD,EAASM,GAAUA,EAAQ,GAAMA,EAE3C,GAAoB,iBAATL,EACT,OAAiB,IAAVA,EAAcA,GAASA,EAEhCA,EAAQA,EAAMO,QAAQ9B,EAAQ,IAC9B,IAAI+B,EAAW7B,EAAW8B,KAAKT,GAC/B,OAAQQ,GAAY5B,EAAU6B,KAAKT,GAC/BnB,EAAamB,EAAMlF,MAAM,GAAI0F,EAAW,EAAI,GAC3C9B,EAAW+B,KAAKT,GAxWb,KAwW6BA,EAGvC,MAtPA,SAAkBU,EAAMC,EAAMlJ,GAC5B,IAAImJ,EACAC,EACAC,EACAlE,EACAmE,EACAC,EACAC,EAAiB,EACjBC,GAAU,EACVC,GAAS,EACTC,GAAW,EAEf,GAAmB,mBAARV,EACT,MAAM,IAAIW,UArIQ,uBA+IpB,SAASC,EAAWC,GAClB,IAAIC,EAAOZ,EACPa,EAAUZ,EAKd,OAHAD,EAAWC,OAAWa,EACtBT,EAAiBM,EACjB3E,EAAS8D,EAAKiB,MAAMF,EAASD,GAI/B,SAASI,EAAYL,GAMnB,OAJAN,EAAiBM,EAEjBR,EAAUc,WAAWC,EAAcnB,GAE5BO,EAAUI,EAAWC,GAAQ3E,EAWtC,SAASmF,EAAaR,GACpB,IAAIS,EAAoBT,EAAOP,EAM/B,YAAyBU,IAAjBV,GAA+BgB,GAAqBrB,GACzDqB,EAAoB,GAAOb,GANJI,EAAON,GAM8BH,EAGjE,SAASgB,IACP,IAAIP,EAAO1B,IACX,GAAIkC,EAAaR,GACf,OAAOU,EAAaV,GAGtBR,EAAUc,WAAWC,EAzBvB,SAAuBP,GACrB,IAEI3E,EAAS+D,GAFWY,EAAOP,GAI/B,OAAOG,EAASxB,EAAU/C,EAAQkE,GAHRS,EAAON,IAGkCrE,EAoBhCsF,CAAcX,IAGnD,SAASU,EAAaV,GAKpB,OAJAR,OAAUW,EAINN,GAAYR,EACPU,EAAWC,IAEpBX,EAAWC,OAAWa,EACf9E,GAeT,SAASuF,IACP,IAAIZ,EAAO1B,IACPuC,EAAaL,EAAaR,GAM9B,GAJAX,EAAWyB,UACXxB,EAAWnJ,KACXsJ,EAAeO,EAEXa,EAAY,CACd,QAAgBV,IAAZX,EACF,OAAOa,EAAYZ,GAErB,GAAIG,EAGF,OADAJ,EAAUc,WAAWC,EAAcnB,GAC5BW,EAAWN,GAMtB,YAHgBU,IAAZX,IACFA,EAAUc,WAAWC,EAAcnB,IAE9B/D,EAIT,OAxGA+D,EAAOV,EAASU,IAAS,EACrBZ,EAAStI,KACXyJ,IAAYzJ,EAAQyJ,QAEpBJ,GADAK,EAAS,YAAa1J,GACH+H,EAAUS,EAASxI,EAAQqJ,UAAY,EAAGH,GAAQG,EACrEM,EAAW,aAAc3J,IAAYA,EAAQ2J,SAAWA,GAiG1De,EAAUG,OAnCV,gBACkBZ,IAAZX,GACFwB,aAAaxB,GAEfE,EAAiB,EACjBL,EAAWI,EAAeH,EAAWE,OAAUW,GA+BjDS,EAAUK,MA5BV,WACE,YAAmBd,IAAZX,EAAwBnE,EAASqF,EAAapC,MA4BhDsC,GCjNTjL,EAAEuL,QAAQC,OAASxL,EAAEuL,QAAQnL,OAAO,CAChCC,oBAAWE,GACPP,EAAEU,WAAWF,KAAMR,EAAEI,OAAO,CACxBqL,SAAU,IACVvJ,QAAS,GACV3B,KAGPmL,eAAMpL,GACFO,IAAM8K,EAAarL,EAAIsL,eAAetJ,GAAK,MACrCuJ,EAAY7L,EAAE8L,QAAQC,OAAO,MAAO,cACpCC,EAAQhM,EAAE8L,QAAQC,OAAO,QAAS,KAAMF,GAC9CG,EAAMzH,KAAO,OACbyH,EAAMC,aAAa,OAAQN,GAC3B3L,EAAEkM,SAASC,GAAGH,EAAO,QAASP,GAAS,SAASW,GAClCA,EAAEC,OAAOvD,MACbhF,QAAUtD,KAAKD,QAAQ2B,SACzB5B,EAAIgM,UAAUpK,QAAQkK,EAAEC,OAAOvD,MAAO1G,KAE3C5B,KAAKD,QAAQkL,UAAWjL,MAC3BR,EAAEkM,SAASC,GAAGH,EAAO,UAAU,SAAUI,GACrCvL,IAAM0L,EAAMH,EAAEC,OAAOvD,MACjBhI,EAAOsB,EAASoK,WACpBJ,EAAEC,OAAOvD,MAAQ,GACjB+C,EAAUY,UAAUC,OAAO,QAC3B,IAAKtF,IAAIuF,EAAI,EAAGA,EAAI7L,EAAKgD,OAAQ6I,IAC7B,GAAIJ,EAAIK,WAAW9L,EAAK6L,GAAGE,WAEvB,YADArM,KAAK8L,UAAUjK,OAAOvB,EAAK6L,GAAGG,QAAQxK,IAI9C9B,KAAKqD,QAAQ0I,KACdjM,GACHO,IAAMkM,EAAS/M,EAAE8L,QAAQC,OAAO,SAAU,KAAMF,GAChDkB,EAAO7J,UAAY,4aACnB6J,EAAOC,MAAQ,SACfhN,EAAEkM,SAASC,GAAGY,EAAQ,SAAS,SAASX,GACpCA,EAAEa,iBACFb,EAAEc,kBACF1M,KAAK2M,WACN3M,MACHK,IAAMuB,EAAWpC,EAAE8L,QAAQC,OAAO,WAAY,KAAMF,GAEpD,OADAzJ,EAASE,GAAKqJ,EACPE,GAGXsB,kBACItM,IAAMuM,EAAI5M,KAAKoL,eACXyB,EAAKD,EAAEX,UACPa,EAAQD,EAAGE,SAAS,QACxBF,EAAGF,OAAO,QACJG,GACFF,EAAEI,SAAS,GAAGC,WAK1BzN,EAAE0N,QAAQ3K,OAAS,SAASxC,GACxB,OAAO,IAAIP,EAAEuL,QAAQC,OAAOjL,IAGhCP,EAAE2N,IAAIC,QAAQ,CACVC,OAAQ,KAERjM,qBAAYC,EAAQC,EAAMC,GAEtB,GADAvB,KAAKwB,KAAK,WAAY,CAAEH,OAAQA,EAAQC,KAAMA,EAAMC,MAAOA,IACvDvB,KAAKqN,OACLrN,KAAKqN,OAAOC,UAAUjM,OAErB,CACDhB,IAAMkN,EAAevN,KAAKD,QAAQwN,cAAgB/N,EAAE6N,OACpDrN,KAAKqN,OAASE,EAAalM,GAAQmM,MAAMxN,MAEzCA,KAAKD,QAAQ0N,IACTnM,EAAMtB,KAAK0N,YAAYpM,GACtBtB,KAAK2N,MAAMtM,GAEZC,EAAMtB,KAAK4N,UAAUtM,GACpBtB,KAAK6N,MAAMxM,IAIxBgC,iBAAQ1B,GAEJ,OADA3B,KAAK8L,UAAUzI,QAAQ1B,GAChB3B,MAGX8N,qBAAYC,EAAMhO,GAEd,sBAFwB,IACxBC,KAAK8L,UAAY,IAAItM,EAAEC,IAAIsO,GAAM/N,KAAMD,GAChCC,QAIfR,EAAE2N,IAAIa,aAAY,WACdhO,KAAK8N,YAAY,YAAa"
}